<?php

namespace RtRasel\LaravelInstaller\Controllers;

use Illuminate\Routing\Controller;
use RtRasel\LaravelInstaller\Helpers\FinalInstallManager;
use RtRasel\LaravelInstaller\Helpers\InstalledFileManager;

class FinalController extends Controller
{
    /**
     * Update installed file and display finished view.
     *
     * @param  \RtRasel\LaravelInstaller\Helpers\InstalledFileManager  $fileManager
     * @param  \RtRasel\LaravelInstaller\Helpers\FinalInstallManager  $finalInstall
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function finish(InstalledFileManager $fileManager, FinalInstallManager $finalInstall)
    {
        $finalInstall->runFinal();
        $fileManager->update();

        return view('laravelinstaller::finished');
    }
}
